var Highscores = {
	run: function() {
		var file = OpenFile("Highscores.sav");
		
		var x = SCREENWIDTH * 0.5 - 30;
		var y = SCREENHEIGHT / 2;
		
		var mm = new Menu(25, SCREENHEIGHT - 40, 90, 20);
		mm.addDefaultKeys(Keys.UP, Keys.DOWN, Keys.LEFT, Keys.RIGHT, Keys.ACCEPT, Keys.CANCEL);
		//mm.setWindowStyle(WINDOW);
		mm.setArrow(ARROWMENU);
		mm.addText("Back", function() {
			mm.escape_function();
		}, FONT, CreateColor(255, 255, 255), CreateColor(255, 204, 0));
		
		BACKGROUND.blit(0, 0);
		WINDOW.drawWindow(20, 20, SCREENWIDTH - 40, SCREENHEIGHT - 40);
		DrawText(30, 30, "HIGH SCORES");
		for(var i=0;i<10;i++) {
			DrawText(30, 50 + i * 14, (i+1) + ". " + HSNames[i]);
			DrawText(200, 50 + i * 14, HSScores[i]);
		}
		var img = GrabImage(0, 0, SCREENWIDTH, SCREENHEIGHT);
		
		mm.preRender = function() {
			img.blit(0, 0);
		}
		mm.escapeable = function(){ return true; }
		
		mm.execute();
	}
};

function AddToHighscores(name) {
	for(var i=0;i<10;i++) {
		if(Score > HSScores[i]) {
			HSScores.splice(i, 0, Score);
			HSNames.splice(i, 0, name);
			HSScores.pop();
			HSNames.pop();
			break;
		}
	}
	// save.
	var file = OpenFile("Highscores.sav");
	for(var i=0;i<10;i++) {
		file.write("SCORE" + (i+1), HSScores[i]);
		file.write("NAME" + (i+1), HSNames[i]);
	}
	file.close();
}

function IsNewHighscore() {
	return Score > HSScores[9];
}